%{
This m-file belongs to Chapter 5 of the dissertation 'Electrochemical CO2
conversion with a flow-through copper hollow fibre'
Anne Sustronk (1,2)
(1) Films in Fluids, Department of Science and Technology, University of 
Twente, Enschede, The Netherlands
(2) Photocatalytic Synthesis Group, Department of Science and Technology, 
University of Twente, Enschede, The Netherlands

The file is used to prepare Table 5.1 in the chapter.

This file is called by PlotWetDry.m and CalcErr_WetDry.m.

Brief overview of experimental conditions: 10 ml/min CO2 through fibre and 
20 ml/min CO2 through head space, 0.5M KHCO3, other conditions same as 
in Chapter 4.

Version date m-file: March 22, 2023
%}

function [XandCI] = CalcErr_WetDry(X, Y,ppmErr,YExp)

        % Remove NaN from Y vector
        Y(isnan(Y)) = [];
        
        % Calculate average and standard deviation of average
        Yavg = mean(Y);
        SD_Y = std(Y);

        % Estimate X value and standard deviation in X value
        XEstim = (YExp*X)./Yavg;
        XErr = sqrt((ppmErr/X)^2+(SD_Y/Yavg)^2).*XEstim;

        % Output
        XandCI = [XEstim' XErr];
        
end